function initAutocomplete() {
    var pickupInput = document.getElementById('pickup');
    var dropoffInput = document.getElementById('dropoff');

    var autocompleteOptions = {
        types: ['geocode'],
        componentRestrictions: {country: 'us'},
        strictBounds: true
    };

    var pickupAutocomplete = new google.maps.places.Autocomplete(pickupInput, autocompleteOptions);
    var dropoffAutocomplete = new google.maps.places.Autocomplete(dropoffInput, autocompleteOptions);

    pickupAutocomplete.addListener('place_changed', function () {
        var place = pickupAutocomplete.getPlace();
        console.log('Pickup Address:', place.formatted_address);
        pickupInput.value = place.formatted_address; // Set input value manually
    });

    dropoffAutocomplete.addListener('place_changed', function () {
        var place = dropoffAutocomplete.getPlace();
        console.log('Dropoff Address:', place.formatted_address);
        dropoffInput.value = place.formatted_address; // Set input value manually
    });

    document.querySelector('.bookReservation').addEventListener('click', function () {
        var form = document.getElementById('reservationForm');
        var formData = new FormData(form);

        // Manually add pickup and dropoff values to FormData
        formData.append('pickup', pickupInput.value);
        formData.append('dropoff', dropoffInput.value);

        // Example using fetch API
        fetch('http://localhost/angelsluxurylimo/includes/booking_form.php', {
            method: 'POST',
            body: formData
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if(data.success === true) {
                    console.log('Book Reservation Response:', data);
                    console.log('success true');
                    form.reset();
                    // Show success message using SweetAlert
                    Swal.fire({
                        icon: 'success',
                        title: 'Booking Successful!',
                        text: 'Your reservation has been successfully booked. Our Team will contact you shortly',
                        timerProgressBar: true,
                        showConfirmButton: false
                    });
                    // Optionally handle response data here
                } else {
                    console.log('success false');
                    // Show failure message using SweetAlert
                    Swal.fire({
                        icon: 'error',
                        title: 'Booking Failed',
                        text: 'There was an error while processing your booking request. Please try again later.',
                        confirmButtonText: 'OK'
                    });
                }
            })
            .catch(error => {
                console.error('Error during book reservation:', error);
                // Show error message using SweetAlert
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'There was an error during the booking process. Please try again later.',
                    confirmButtonText: 'OK'
                });
            });
    });

}