
<?php

// Check if the request is a POST request
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $pickup = $_POST['pickup'] ?? '';
    $dropoff = $_POST['dropoff'] ?? '';
    $name = $_POST['namme'] ?? ''; // Note: Corrected typo in 'namme'
    $phone = $_POST['phone'] ?? '';
    $email = $_POST['email'] ?? '';
    $package = $_POST['package'] ?? '';
    $passengers = $_POST['passengers'] ?? '';
    $date = $_POST['date'] ?? '';
    $time = $_POST['time'] ?? '';

    // For demonstration, we'll just return a JSON response with the received data
    $response = [
        'pickup' => $pickup,
        'dropoff' => $dropoff,
        'name' => $name,
        'phone' => $phone,
        'email' => $email,
        'package' => $package,
        'passengers' => $passengers,
        'date' => $date,
        'time' => $time,
        'timestamp' => date('Y-m-d H:i:s'),
    ];

    // Send email (example)
    $to = 'your-email@example.com';
    $subject = 'New Reservation';
    $message = "New reservation details:\n";
    $message .= "Pickup: $pickup\n";
    $message .= "Dropoff: $dropoff\n";
    $message .= "Name: $name\n";
    $message .= "Phone: $phone\n";
    $message .= "Email: $email\n";
    $message .= "Package: $package\n";
    $message .= "Passengers: $passengers\n";
    $message .= "Date: $date\n";
    $message .= "Time: $time\n";

    // Optionally, you can use PHP's mail function to send email
    // mail($to, $subject, $message);

    // Return JSON response (you can customize this response as needed)
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'message' => 'Reservation successfully submitted', 'data' => $response]);
    exit;
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['success' => false, 'error' => 'Method Not Allowed']);
    exit;
}

?>
